# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    total_rounds = len(my_history) + 1
    if total_rounds == 1:
        return "C"
    
    opp_coop_rate = opp_history.count("C") / len(opp_history)
    recent_opp_moves = opp_history[-2:] if len(opp_history) >= 2 else opp_history
    
    # Initial Phase: Build trust
    if total_rounds <= 3:
        if "D" in opp_history:
            return "D"
        return "C"
    
    # Mid-Game: Conditional response
    if 4 <= total_rounds <= 7:
        if opp_coop_rate >= 0.75:
            if recent_opp_moves == ["D", "D"]:
                return "D"
            return "C"
        elif opp_coop_rate <= 0.6:
            return "D" if random.random() < 0.7 else "C"
        return "C"
    
    # Late-Game: Exploit or maintain
    if total_rounds >= 8:
        if "if total_rounds >= 9" in opponent_program_code:
            return "D"
        if opp_coop_rate == 1.0:
            return "D"
        return "C"
    
    return "C"